#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int calculate_happiness(const vector<int>& row1, const vector<int>& row2) {
    int n = row1.size(); 
    int happiness = 0;

    int current_parity = row1[0] % 2; 
    
    for (int j = 0; j < n; ++j) {
        int next_parity;
        if (j % 2 == 0) {  
            next_parity = row1[j] % 2;
        } else { 
            next_parity = row2[j / 2] % 2;
        }

        if (next_parity == current_parity) {
            happiness += 1;
        }

        current_parity = next_parity;
    }

    int max_happiness = happiness;

    for (int j = 0; j < n; ++j) {
        int original_parity, swapped_parity;
        if (j % 2 == 0) { 
            original_parity = row1[j] % 2;
            swapped_parity = row2[j] % 2;
        } else {  
            original_parity = row2[j / 2] % 2;
            swapped_parity = row1[j / 2] % 2;
        }
        
        int new_happiness = happiness;
        
        if (j > 0) {
            int prev_parity = (j - 1) % 2 == 0 ? row1[j - 1] % 2 : row2[(j - 1) / 2] % 2;
            if (swapped_parity == prev_parity) {
                new_happiness += 1;
            }
            if (original_parity == prev_parity) {
                new_happiness -= 1;
            }
        }
        
        if (j < n - 1) {
            int next_parity = (j + 1) % 2 == 0 ? row1[j + 1] % 2 : row2[(j + 1) / 2] % 2;
            if (swapped_parity == next_parity) {
                new_happiness += 1;
            }
            if (original_parity == next_parity) {
                new_happiness -= 1;
            }
        }
        
        max_happiness = max(max_happiness, new_happiness);
    }

    return max_happiness;
}

int main() {
    int T;
    cin >> T;  
    while (T--) {
        int N;
        cin >> N; 
        vector<int> row1(N);
        vector<int> row2(N);

        for (int i = 0; i < N; ++i) {
            cin >> row1[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> row2[i];
        }

        int max_happiness = calculate_happiness(row1, row2);
        cout << max_happiness << endl;
    }

    return 0;
}